/******************************************************************************		
*                                                                                   	
*       Copyright (C) 2008 Freescale Semiconductor, Inc.                            	
*       All Rights Reserved								              				
*														              					
* Filename:       SCI_DRV.H               											
*														              					
* Description:	  SCI Header file for MC9S08DZ60	        	    	
*                 based on Specification Rev. 3  	       						
*																						
* Notes:        																		
*  ***********************************************************************  			
*  *  THIS CODE IS ONLY INTENDED AS AN EXAMPLE OF CODE FOR THE           *  	 		
*  *  FREESCALE CW COMPILER AND HAS ONLY BEEN GIVEN A MIMIMUM            *  	 		
*  *  LEVEL OF TEST. IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES         *  	 		
*  *  AND NO PROMISE OF SUPPORT.                                         *  	 		
*  ***********************************************************************  	 		
*																						
* Freescale reserves the right to make changes without further notice to any			
* product herein to improve reliability, function, or design. Freescale does	 		
* not assume any  liability arising  out  of the  application or use of any 	 		
* product,  circuit, or software described herein;  neither  does it convey 	 		
* any license under its patent rights  nor the  rights of others.  Freescale	 		
* products are not designed, intended,  or authorized for use as components 	 		
* in  systems  intended  for  surgical  implant  into  the  body, or  other 	 		
* applications intended to support life, or  for any  other application  in 	 		
* which the failure of the Freescale product  could create a situation where	 		
* personal injury or death may occur. Should Buyer purchase or use Freescale	 		
* products for any such intended  or unauthorized  application, Buyer shall 	 		
* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,	 		
* affiliates,  and distributors harmless against all claims costs, damages, 	  		
* and expenses, and reasonable  attorney  fees arising  out of, directly or 	 		
* indirectly,  any claim of personal injury  or death  associated with such 	 		
* unintended or unauthorized use, even if such claim alleges that  Freescale	 		
* was negligent regarding the  design  or manufacture of the part. Freescale	 		
* and the Freescale logo* are registered trademarks of Freescale Ltd.       	 		
******************************************************************************/		
/******************************************************************************/
#ifndef SCI_DRV_H        /*prevent duplicated includes*/
#define SCI_DRV_H

/************************* Project Include Files *****************************/

/************************* Variables *****************************/

typedef struct				/*sci datastructure	*/
  {
  volatile SCI1BDSTR  SCIBD;	/*WORD - sci baud rate register(s) */
  volatile SCI1C1STR	SCICR1;	/*sci control register 1 */
  volatile SCI1C2STR	SCICR2;	/*sci control register 2 */
  volatile SCI1S1STR	SCISR1;	/*sci status register 1	*/
  volatile SCI1S2STR	SCISR2;	/*sci status register 2	*/
  volatile SCI1C3STR	SCICR3;	/*sci control register 3 */
  volatile SCI1DSTR  	SCIDR;	/*sci data register low	*/
  }tSCI;
  
/************************* #Defines ******************************************/

extern tSCI *TerminalPointer; /* Global Variable indicating which SCI is in use */

#define SCI1 (*(volatile tSCI*) (0x0038))
#define SCI2 (*(volatile tSCI*) (0x0040))
 
/************************* Macros ********************************************/

#define _CR PutChar(\r)
#define _LF PutChar(\n)
#define NEW_LINE DisplayString("\r\n")
#define LF NEW_LINE							
#define FF DisplayString("\f")

/************************* Prototypes ****************************************/

void SCI_Config(tSCI *, unsigned int);
unsigned char convertASCII(unsigned char);
void DisplayByte(unsigned char); 
void DisplayString (signed char*);
void PutChar (char);
void DisplayLong(unsigned long, unsigned char); 
void DisplayInt(unsigned int, unsigned char);
char GetChar(void);
char EchoGetChar(void);

#endif /* SCI_DRV_H */